<?php
/**
 * Datenschutzerklärung
 * German Shield by GermanProWeb
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="german-shield-legal-page" style="max-width: 900px; margin: 0 auto; padding: 40px 20px;">
    <h1 style="font-size: 32px; margin-bottom: 30px; color: #1d2327;">Datenschutzerklärung</h1>
    
    <div style="background: #f9f9f9; padding: 20px; border-radius: 8px; margin-bottom: 30px; border-left: 4px solid #22D6DD;">
        <p style="margin: 0; font-size: 14px; color: #646970;">
            <strong>German Shield by GermanProWeb</strong><br>
            Stand: November 2025
        </p>
    </div>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">1. Verantwortliche Stelle</h2>
        <p style="line-height: 1.8; color: #1d2327;">
            Verantwortlich für die Datenverarbeitung durch German Shield ist:<br><br>
            <strong>GermanProWeb</strong><br>
            Website: german-shield.de<br>
            E-Mail: datenschutz@germanproweb.de
        </p>
    </section>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">2. Datenverarbeitung durch das Plugin</h2>
        <p style="line-height: 1.8; color: #1d2327; margin-bottom: 15px;">
            <strong>2.1 Formularvalidierung:</strong><br>
            German Shield speichert zur Spam-Abwehr folgende Daten von Formular-Anfragen:
        </p>
        <ul style="line-height: 1.8; color: #1d2327; margin-left: 20px;">
            <li>IP-Adresse des Absenders</li>
            <li>Zeitstempel der Anfrage</li>
            <li>Validierungsergebnis (blockiert/legitim)</li>
            <li>Blockierungsgrund bei Spam-Erkennung</li>
            <li>Optional: Formularinhalte (nur bei Blockierung für Analyse)</li>
        </ul>
        <p style="line-height: 1.8; color: #1d2327; margin-top: 15px;">
            <strong>Rechtsgrundlage:</strong> Berechtigtes Interesse an Spam-Schutz (Art. 6 Abs. 1 lit. f DSGVO)
        </p>
    </section>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">3. Free-Lizenz & E-Mail-Verifizierung</h2>
        <p style="line-height: 1.8; color: #1d2327;">
            <strong>3.1 Datenerhebung:</strong><br>
            Bei Aktivierung der Free-Version per E-Mail-Verifizierung speichern wir:
        </p>
        <ul style="line-height: 1.8; color: #1d2327; margin-left: 20px;">
            <li>E-Mail-Adresse</li>
            <li>Verifizierungstoken (einmalig, 24h gültig)</li>
            <li>Verifizierungsstatus und -zeitpunkt</li>
            <li>Generierter Free-License-Key</li>
        </ul>
        <p style="line-height: 1.8; color: #1d2327; margin-top: 15px;">
            <strong>Rechtsgrundlage:</strong> Vertragserfüllung (Art. 6 Abs. 1 lit. b DSGVO)
        </p>
        <p style="line-height: 1.8; color: #1d2327; margin-top: 15px;">
            <strong>3.2 Speicherdauer:</strong><br>
            Ihre E-Mail-Adresse wird solange gespeichert, bis Sie die Free-Lizenz deaktivieren oder uns um Löschung bitten.
        </p>
    </section>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">4. GEO-Blocking & IP-Geolokalisierung</h2>
        <p style="line-height: 1.8; color: #1d2327;">
            Bei aktiviertem GEO-Blocking wird die IP-Adresse über den externen Dienst <strong>ip-api.com</strong> 
            zur Länder-Bestimmung abgefragt. Diese Abfrage erfolgt in Echtzeit und die IP wird nicht dauerhaft gespeichert.
        </p>
        <p style="line-height: 1.8; color: #1d2327; margin-top: 15px;">
            <strong>Rechtsgrundlage:</strong> Berechtigtes Interesse an Spam-Schutz (Art. 6 Abs. 1 lit. f DSGVO)<br>
            <strong>Datenempfänger:</strong> ip-api.com (USA) - Datenschutz: <a href="https://ip-api.com/docs/legal" target="_blank" style="color: #22D6DD;">ip-api.com/legal</a>
        </p>
    </section>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">5. Premium-Lizenzierung</h2>
        <p style="line-height: 1.8; color: #1d2327;">
            Bei Kauf einer Premium-Lizenz werden Zahlungs- und Lizenzd aten auf sicheren Servern gespeichert:
        </p>
        <ul style="line-height: 1.8; color: #1d2327; margin-left: 20px;">
            <li>Lizenzschlüssel & Domain</li>
            <li>Laufzeit & Status</li>
            <li>Zahlungsinformationen (über Zahlungsdienstleister)</li>
        </ul>
        <p style="line-height: 1.8; color: #1d2327; margin-top: 15px;">
            <strong>Rechtsgrundlage:</strong> Vertragserfüllung (Art. 6 Abs. 1 lit. b DSGVO)
        </p>
    </section>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">6. Ihre Rechte</h2>
        <p style="line-height: 1.8; color: #1d2327;">
            Sie haben folgende Rechte bezüglich Ihrer personenbezogenen Daten:
        </p>
        <ul style="line-height: 1.8; color: #1d2327; margin-left: 20px;">
            <li><strong>Auskunftsrecht:</strong> Welche Daten werden gespeichert?</li>
            <li><strong>Berichtigungsrecht:</strong> Korrektur falscher Daten</li>
            <li><strong>Löschungsrecht:</strong> "Recht auf Vergessenwerden"</li>
            <li><strong>Einschränkung der Verarbeitung</strong></li>
            <li><strong>Widerspruchsrecht:</strong> Gegen Datenverarbeitung widersprechen</li>
            <li><strong>Datenübertragbarkeit:</strong> Ihre Daten in maschinenlesbarem Format erhalten</li>
        </ul>
        <p style="line-height: 1.8; color: #1d2327; margin-top: 15px;">
            Kontakt: datenschutz@germanproweb.de
        </p>
    </section>
    
    <section style="margin-bottom: 30px;">
        <h2 style="font-size: 24px; margin-bottom: 15px; color: #1d2327;">7. Datensicherheit</h2>
        <p style="line-height: 1.8; color: #1d2327;">
            Alle Daten werden verschlüsselt über HTTPS übertragen. Die Speicherung erfolgt auf sicheren Servern 
            in Deutschland/EU mit technischen und organisatorischen Maßnahmen nach aktuellem Stand der Technik.
        </p>
    </section>
    
    <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #c3cbd5;">
        <p style="text-align: center; color: #646970; font-size: 14px;">
            <strong>GermanProWeb</strong><br>
            Website: <a href="https://german-shield.de" target="_blank" style="color: #22D6DD; text-decoration: underline;">german-shield.de</a><br>
            Datenschutz: datenschutz@germanproweb.de
        </p>
    </div>
</div>

